(defmeth vista-RewCat-proto :define-model-terms-window (terms-in-model-name-list terms) 
  (let ((v-rewcat-proto self))
  (if 
   (= (length (send self :terms)) 1)
   (send terms-in-model-name-list :selection 
         (iseq (length (combine (send self :terms)))))
   (send terms-in-model-name-list :selection (combine (last (send self :terms)))))
  (send terms-in-model-name-list :has-h-scroll t)
  (setf reference-category-menu  
          (send menu-item-proto :new "Reference Categories..." 
                :action #'(lambda () 
                            (send v-rewcat-proto  :reference-category-dialog 
                                  (send terms-in-model-name-list :spreadplot-object)))))
  (setf be-h-menu-item  
          (send menu-item-proto :new "Be Non-Hierarchical" 
                :action #'(lambda () 
                            (send v-rewcat-proto :be-hierarchic?
                                  (if (send v-rewcat-proto :be-hierarchic?) 
                                      nil t))
                            (send be-h-menu-item :update))))
                            
    (defmeth be-h-menu-item :update ()
      (if (send v-rewcat-proto :be-hierarchic?) 
                                (send self :title "Be Non-Hierarchical")
                                (send self :title "Be Hierarchical")))
	    ;install menu for changing reference categories
    
  (send
   (send terms-in-model-name-list :menu) :append-items be-h-menu-item reference-category-menu)


   (defmeth terms-in-model-name-list :do-select-click (x y m1 m2)
     (when m2 
          	(send self :start-buffering)
          	(let* ((prev-selection (send self :selection))
                 	)
           		(call-next-method x y m1 m2)
           		(when (and (send self :selection) 
                  			   (not (intersection (send self :selection) prev-selection))
                    				(< (first (send self :selection)) (length terms)))
                			(send v-rewcat-proto :build-indicators-dialog 
                     				(send self :selection) x y self)
                 		)
             
            	(send self :selection prev-selection)
            	(send self :redraw)
            	(send self :buffer-to-screen)))
     
     (when (not m2)
           (setf bhierarchic (send v-rewcat-proto :be-hierarchic?))
           (cond 
             (bhierarchic
              (when m1
                    (setf prev-selected (send self :selection))
                    (send self :start-buffering)
                    (when (and prev-selected m1) (send self :selection (list nil)))
                    )
              (call-next-method x y m1 m2)

            #|  (when (not (send self :selection))
                    (setf indicators-selected nil)
                    (setf selection-without-indicators nil)
                    (send v-rewcat-proto :terms (append (send v-rewcat-proto :terms) 
                                                        (list (list nil))))
                    
                    (send v-rewcat-proto :blocks (append (send v-rewcat-proto :blocks) (list nil)))
                    
                    (send v-rewcat-proto :models-adjusted-list
                          (combine
                           (send v-rewcat-proto :models-adjusted-list)
                           (regression-model (repeat '1 (length (send v-rewcat-proto :y-vector)))
                                             (send v-rewcat-proto :y-vector)
                                             :intercept nil
                                             :response-name (send v-rewcat-proto :y-name)
                                             :predictor-names (list "Const")
                                             )))
                     
                    (send v-rewcat-proto :model 
                          (append (send v-rewcat-proto :model) 
                                  (list (remove 'nil (combine 
                                                      (select (send v-rewcat-proto :list-terms) 
                                                            		list-terms)
                                                     	(if indicators-selected 
                                                          (mapcar #'(lambda (indic) (first indic))
                                                                  (select 
                                                                   (send v-rewcat-proto  												:indicators-list) 
                                                                   (- indicators-selected (length terms))))
                                                          nil))))))
                    (send v-rewcat-proto :curr-model 
                          (car (reverse (send v-rewcat-proto :models-adjusted-list))))
                   
                    (send (send self :spreadplot-object)
                          :update-spreadplot "terms" 0 
                          selection-without-indicators)
                    
                    )|#
           
                    
           			
              (when (send self :selection)
                    (when m1
                          (setf post-selected (send self :selection))
                          (send self :selection 
                                (set-difference (combine prev-selected post-selected)
                                                (intersection prev-selected post-selected)))
                          (send self :redraw)
                          (send self :buffer-to-screen)
                          )
                    (setf selection-without-indicators 	
                          (select (send self :selection) 
                                  (which (mapcar #'(lambda (sel) (< sel (length terms)))
                                                 (send self :selection)))))
                   	
                    (setf indicators-selected 
                          (select (send self :selection) 
                                  (which (mapcar #'(lambda (sel) (>= sel (length terms)))
                                                 (send self :selection)))))
                    
                    (when indicators-selected
                     (setf indicators-selected 
                          	(select indicators-selected
                                   (which 
                                    (mapcar #'(lambda (indic-selec)
                                                (null (member indic-selec 
                                                              (combine 
                                                               (mapcar #'(lambda (term) 
                                                                           (send v-rewcat-proto :make-names-term term))
                                                                       selection-without-indicators)):test 'equal)))
                                            (mapcar 'first (select (send v-rewcat-proto :indicators-list) 
                                                                  	(- indicators-selected (length terms) ) )))))))
                  
                    (let* ((list-terms
                            (combine 
                             (mapcar #'(lambda (term) 
                                         (which (mapcar #'(lambda (term2) 
                                                            (equal term term2))
                                                        terms)))
                                     (expand-hierarchy 
                                      (select terms selection-without-indicators)))))
                       				
                           (terms-in-model 
                            (if selection-without-indicators
                                (expand-hierarchy
                              	  (select terms selection-without-indicators))
                          						nil))
                           (design-matrix (design-matrix (send v-rewcat-proto :x-matrix)
                                                              (send v-rewcat-proto :variable-types)
                                                              terms-in-model
                                                              (send v-rewcat-proto :vars)))
                           )

                      (send self :selection (combine list-terms indicators-selected))
                      

                      (send v-rewcat-proto :terms (append (send v-rewcat-proto :terms) 
                                                      (list (remove 'nil (combine list-terms indicators-selected)))))
                    
                      (send v-rewcat-proto :blocks (append (send v-rewcat-proto :blocks) (list (third design-matrix))))
                    
                       (send v-rewcat-proto :models-adjusted-list
                            (combine
                             (send v-rewcat-proto :models-adjusted-list)
                             (regression-model (first design-matrix)
                                               (send v-rewcat-proto :y-vector)
                                               :response-name (send v-rewcat-proto :y-name)
                                               :predictor-names (second design-matrix))
                             ))
                     
                      (send v-rewcat-proto :model 
                            (append (send v-rewcat-proto :model) 
                                    (list (remove 'nil (combine 
							(select (send v-rewcat-proto :list-terms) 
                                                  		list-terms)
								(if indicators-selected 
									(mapcar #'(lambda (indic) (first indic))
										(select 
											(send v-rewcat-proto  												:indicators-list) 
									(- indicators-selected (length terms))))
								  nil)

							)))))
                   (send v-rewcat-proto :curr-model 
                         (car (reverse (send v-rewcat-proto :models-adjusted-list))))
                   
                   (send (send self :spreadplot-object)
                         :update-spreadplot "terms" 0 
                         selection-without-indicators)
                    
                      )))
                  
                  (t
                   (when m1
                         (setf prev-selected (send self :selection))
                         (send self :start-buffering)
                         (when (and prev-selected m1) (send self :selection (list nil)))
                         )
                   (call-next-method x y m1 m2)
                   (when (send self :selection)
                   (when m1
                         (setf post-selected (send self :selection))
                         (send self :selection 
                               (set-difference (combine prev-selected post-selected)
                                               (intersection prev-selected post-selected)))
                         )


			(setf selection-without-indicators 	(select (send self :selection) 
								(which (mapcar #'(lambda (sel) (< sel (length terms)))
									 (send self :selection)))))
	
			(setf indicators-selected (select (send self :selection) 
								(which (mapcar #'(lambda (sel) (>= sel (length terms)))
									 (send self :selection)))))
		 (when indicators-selected
				(setf indicators-selected 
				(select indicators-selected
					(which (mapcar #'(lambda (indic-selec)
						(null (member indic-selec (combine 
								(mapcar #'(lambda (term) 
									(send v-rewcat-proto :make-names-term term))
								selection-without-indicators)):test 'equal)))
					(mapcar 'first (select (send v-rewcat-proto :indicators-list)
					 (- indicators-selected (length terms) ) )))))))
	

                   (send v-rewcat-proto :terms (append (send v-rewcat-proto :terms) 
                                                   (list (remove 'nil (combine selection-without-indicators 								indicators-selected)))))
              
                   (send v-rewcat-proto :models-adjusted-list
                            (combine
                             (send v-rewcat-proto :models-adjusted-list)
                           (regression-model (first design-matrix)
                                               (send v-rewcat-proto :y-vector)
                                               :response-name (send v-rewcat-proto :y-name)
                                             :predictor-names (second design-matrix))))
              
                   (send v-rewcat-proto :model (append (send v-rewcat-proto :model) 
                                                        (list (remove 'nil (combine 
							(select (send v-rewcat-proto :list-terms) 
                                                  		selection-without-indicators)
								(if indicators-selected 
									(mapcar #'(lambda (indic) (first indic))
										(select 
											(send v-rewcat-proto 												:indicators-list) 
									(- indicators-selected (length terms))))
								  nil)
						)))))
                   (send v-rewcat-proto :curr-model 
                         (car (reverse (send v-rewcat-proto :models-adjusted-list))))
 
                   (send (send self :spreadplot-object)
                         :update-spreadplot "terms" 0 selection-without-indicators)))
             )
     (send self :buffer-to-screen)
     (send self :redraw)))


(defmeth terms-in-model-name-list :update-plotcell (&rest args)
  
      (when (equal (first args) "dev-plot")
            (when (= (length (combine (third args))) 1)
                  (send self :selection 
                        (combine (select
                                  (send v-rewcat-proto :terms)
                                  (first (third args))
                                  )))))
  
  )



))